using System;
using System.Security;
using System.Runtime.Remoting.Messaging;
using System.IO;
using System.ComponentModel;
using System.Reflection;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;


namespace CSharpRecipes
{
	public class DelegatesEventsAnonymousMethods
    {
        #region "9.1 Zarzdzanie czasem i miejscem uruchomienia delegata w obrbie delegata multicast"
        public delegate int MyDelegate();

        public static void InvokeInReverse()
        {
            MyDelegate myDelegateInstance1 = new MyDelegate(TestInvoke.Method1);
            MyDelegate myDelegateInstance2 = new MyDelegate(TestInvoke.Method2);
            MyDelegate myDelegateInstance3 = new MyDelegate(TestInvoke.Method3);

            MyDelegate allInstances =
                    myDelegateInstance1 + 
                    myDelegateInstance2 + 
                    myDelegateInstance3;

            Console.WriteLine("Uruchamianie delegatw w odwrconym porzdku");
	        Delegate[] delegateList = allInstances.GetInvocationList();
	        for (int counter = delegateList.Length - 1; counter >= 0; counter--)
	        {
                ((MyDelegate)delegateList[counter])();
	        }
        }	

        public static void InvokeEveryOtherSetup()
        {
            MyDelegate myDelegateInstance1 = new MyDelegate(TestInvoke.Method1);
            MyDelegate myDelegateInstance2 = new MyDelegate(TestInvoke.Method2);
            MyDelegate myDelegateInstance3 = new MyDelegate(TestInvoke.Method3);

            MyDelegate allInstances = //myDelegateInstance1;
                    myDelegateInstance1 + 
                    myDelegateInstance2 + 
                    myDelegateInstance3;

            InvokeEveryOtherImpl(allInstances);
        }

        public static void InvokeEveryOtherImpl(MyDelegate delegateInstance)
        {
            Delegate[] delegateList = delegateInstance.GetInvocationList();

            // Czy s podczone jakie delegaty.
            if (delegateList.Length > 0)
            {
                Console.WriteLine("Wywoywanie co drugiego delegata");
                for (int counter = 0; counter < delegateList.Length; counter += 2)
                {
                    //  Wywoanie delegata.
                    int retVal = ((MyDelegate)delegateList[counter])();
                }
            }
        }

        public class TestInvoke
        {
	        public static int Method1()
	        {
                Console.WriteLine("Wywoano metod Method1");
		        return (1);
	        }

	        public static int Method2()
	        {
                Console.WriteLine("Wywoano metod Method2");
		        return (2);
	        }

	        public static int Method3()
	        {
		        //throw (new Exception("Method1"));
		        //throw (new SecurityException("Method3"));
                Console.WriteLine("Wywoano metod Method3");
		        return (3);
	        }
        }


        public delegate bool MyDelegateTF();

        public static void InvokeWithTest()
        {
            MyDelegateTF myDelegateInstanceTF1 = new MyDelegateTF(TestInvokeTF.Method1);
            MyDelegateTF myDelegateInstanceTF2 = new MyDelegateTF(TestInvokeTF.Method2);
            MyDelegateTF myDelegateInstanceTF3 = new MyDelegateTF(TestInvokeTF.Method3);

            MyDelegateTF allInstancesTF = 
                    myDelegateInstanceTF1 +
                    myDelegateInstanceTF2 +
                    myDelegateInstanceTF3;

	        Console.WriteLine(
                "Wywoanie indywidualne (na podstawie wartoci zwrconej przez poprzednika):");
            foreach (MyDelegateTF instance in allInstancesTF.GetInvocationList())
	        {
                // Ta przerwa nie jest konieczna. Wprowadzono j po to,
                // by nie dopuci do kontynuowania ptli.
                if (!instance())
                    break;
	        }
        }

        public class TestInvokeTF
        {
	        public static bool Method1()
	        {
                Console.WriteLine("Wywoano metod Method1");
		        return (true);
	        }

	        public static bool Method2()
	        {
                Console.WriteLine("Wywoano metod Method2");
		        return (false);
	        }

	        public static bool Method3()
	        {
                Console.WriteLine("Wywoano metod Method3");
		        return (true);
	        }
        }
        #endregion

        #region "9.2 Odczytywanie zwracanych wynikw wszystkich delegatw wchodzcych w skad delegata multicast"
        public static void TestIndividualInvokesRetVal()
        {
            MyDelegate myDelegateInstance1 = new MyDelegate(TestInvoke.Method1);
            MyDelegate myDelegateInstance2 = new MyDelegate(TestInvoke.Method2);
            MyDelegate myDelegateInstance3 = new MyDelegate(TestInvoke.Method3);

            MyDelegate allInstances =
                    myDelegateInstance1 +
                    myDelegateInstance2 +
                    myDelegateInstance3;

            Console.WriteLine("Wywoanie indywidualne (w celu uzyskania zwracanej wartoci):");
            foreach (MyDelegate instance in allInstances.GetInvocationList())
	        {
		        int retVal = instance();
                Console.WriteLine("\tWynik: " + retVal);
	        }
        }
        #endregion

        #region "9.3 Indywidualna obsuga wyjtkw dla kadego z delegatw w obrbie delegata multicast"
        public class MyExceptionHolderException : Exception
        {
            private List<Exception> _exceptions = null;

            public MyExceptionHolderException()
            {
                _exceptions = new List<Exception>();
            }

            public List<Exception> Exceptions
            {
                get { return _exceptions; }
            }
            
            public void Add(Exception ex)
            {
                if (ex == null)
                    throw new ArgumentNullException("ex");

                _exceptions.Add(ex);
            }

            public void AddRange(Exception [] exceptions)
            {
                if (exceptions == null)
                    throw new ArgumentNullException("ex");

                _exceptions.AddRange(exceptions);
            }
        }

        public static void TestIndividualInvokesExceptions()
        {
            MyDelegate myDelegateInstance1 = new MyDelegate(TestInvoke.Method1);
            MyDelegate myDelegateInstance2 = new MyDelegate(TestInvoke.Method2);
            MyDelegate myDelegateInstance3 = new MyDelegate(TestInvoke.Method3);

            MyDelegate allInstances =
                    myDelegateInstance1 +
                    myDelegateInstance2 +
                    myDelegateInstance3;

            Console.WriteLine("Wywoywanie indywidualne (obsuga wyjtkw):");

            // Utworzenie egzemplarza obiektu opakowujcego obejmujcego wszystkie wyjtki
            // zgaszane podczas wywoywania egzemplarzy delegatw.

            MyExceptionHolderException holderEx = new MyExceptionHolderException();
            
            foreach (MyDelegate instance in allInstances.GetInvocationList())
	        {
		        try
		        {
			        int retVal = instance();
			        Console.WriteLine("\tWynik: " + retVal);
		        }
		        catch (SecurityException se)
		        {
                    // Zatrzymanie przetwarzania. Zagroenie prby dostpu do danych
                    // przez zoliwy kod.


                    // Utworzenie egzemplarza obiektu EventLog  przypisanie mu rda.
                    EventLog myLog = new EventLog();
                    myLog.Source = "MyApplicationSource";
                    // Zapis informacji do dziennika zdarze.
                    myLog.WriteEntry("Bd bezpieczestwa w aplikacji MyApplication! " + 
                        se.ToString(), 
                        EventLogEntryType.Error);
                    // Wznowienie zgoszenia wyjtku w celu 
                    // zatrzymania dziaania aplikacji (poniewa by to bd bezpieczestwa).

                    throw;
		        }
		        catch (Exception e)
		        {
                    // Wywietlenie (lub zarejestrowanie) wyjtku i kontynuowanie dziaania.
			        Console.WriteLine(e.ToString());
                    // Dodanie wyjtku do obiektu opakowujcego.
                    holderEx.Add(e);
		        }
	        }
            // Po przechwyceniu wszystkich wyjtkw, zgoszenie wyjtku opakowujcego
            // ktry je zawiera.
            if (holderEx.Exceptions.Count > 0)
                throw holderEx;
        }
		#endregion

        #region "9.4 Konwersja wywoania delegata z synchronicznego na asynchroniczne"

        public delegate void SyncDelegateTypeSimple();
        public delegate int SyncDelegateType(string message);

        public static void TestSimpleSyncDelegate()
        {
            SyncDelegateTypeSimple sdtsInstance =
                new SyncDelegateTypeSimple(TestSyncDelegateTypeSimple.Method1);
            sdtsInstance();
        }

        public static void TestSimpleAsyncDelegate()
        {
            AsyncCallback callBack = new AsyncCallback(DelegateSimpleCallback);

            SyncDelegateTypeSimple sdtsInstance =
                new SyncDelegateTypeSimple(TestSyncDelegateTypeSimple.Method1);

            IAsyncResult asyncResult = 
                sdtsInstance.BeginInvoke(callBack, null);

            Console.WriteLine("PRZETWARZANIE...");
        }

        public static void TestComplexSyncDelegate()
        {
            SyncDelegateType sdtInstance = 
                new SyncDelegateType(TestSyncDelegateType.Method1);

            int retVal = sdtInstance("Wywoanie synchroniczne");

            Console.WriteLine("Sync: " + retVal);
        }

        public static void TestCallbackAsyncDelegate()
        {
            AsyncCallback callBack = 
                new AsyncCallback(DelegateCallback);

            SyncDelegateType sdtInstance =
                new SyncDelegateType(TestSyncDelegateType.Method1);

            IAsyncResult asyncResult = 
                sdtInstance.BeginInvoke("Wywoanie asynchroniczne", callBack, null);

            Console.WriteLine("PRZETWARZANIE...");
        }

        // Metoda wywoywana zwrotnie po zakoczeniu dziaania 
        // metody TestSyncDelegateTypeSimple.Method1

        private static void DelegateSimpleCallback(IAsyncResult iResult)
        {
            AsyncResult result = (AsyncResult)iResult;
            SyncDelegateTypeSimple sdtsInstance =
                (SyncDelegateTypeSimple)result.AsyncDelegate;

            sdtsInstance.EndInvoke(result);
            Console.WriteLine("Proste wywoanie zwrotne");
        }

        // Metoda wywoywana zwrotnie po zakoczeniu dziaania
        // metody TestSyncDelegateTypeSimple.Method1

        private static void DelegateCallback(IAsyncResult iResult)
        {
            AsyncResult result = (AsyncResult)iResult;
            SyncDelegateType sdtInstance =
                (SyncDelegateType)result.AsyncDelegate;

            int retVal = sdtInstance.EndInvoke(result);
            Console.WriteLine("retVal (Callback): " + retVal);
        }

        // Klasa i metoda wywoywana za porednictwem delegata SyncDelegateTypeSimple
        public class TestSyncDelegateTypeSimple
        {
            public static void Method1()
            {
                Console.WriteLine("Wywoano metod Method1");
            }
        }


        public class TestSyncDelegateType
        {
            public static int Method1(string message)
            {
                Console.WriteLine("Wywoano metod Method1 z komunikatem: " + message);
                return (1);
            }
        }
        #endregion

        #region "9.5 Opakowywanie zapiecztowanych klas w celu dodawania zdarze"
        public static void TestDirectoryInfoObserver()
		{
            // Utworzenie dwch obiektw-obserwatorw.
			DirectoryInfoObserver Observer1 = new DirectoryInfoObserver();
			DirectoryInfoObserver Observer2 = new DirectoryInfoObserver();

            // Utworzenie obiektu powiadomienia dla katalogu c:\testdir.
			DirectoryInfoNotify DirInfo = new DirectoryInfoNotify(@"c:\testdir");

            // Zarejestrowanie obiektu powiadomienie dla obydwu obiektw-obserwatorw.
			Observer1.Register(DirInfo);
			Observer2.Register(DirInfo);

            // Utworzenie katalogu c:\testdir.
			DirInfo.Create();

            // Konfiguracja pierwszego obserwatora w celu obserwacji take  podkatalogu new.
			DirectoryInfoNotify SubDirInfo = DirInfo.CreateSubdirectory("new");
			Observer1.Register(SubDirInfo);

            // Usunicie podkatalogu, a nastpnie katalogu gwnego.
			SubDirInfo.Delete(true);
			DirInfo.Delete(false);

            // Wyrejestrowanie obiektw powiadomie.
			Observer2.UnRegister(DirInfo);
			Observer1.UnRegister(DirInfo);
			
			
//			// Utworzenie obiektu DirectoryInfoObserver oraz DirectoryInfoNotify
//			DirectoryInfoObserver Observer = new DirectoryInfoObserver();
//			DirectoryInfoNotify DirInfo = new DirectoryInfoNotify(@"d:\testdir");
//
//			// Zarejestrowanie obiektu DirectoryInfoNotify object z obiektem DirectoryInfoObserver
//			Observer.Register(DirInfo);
//
//			// Utworzenie katalogu c:\testdir, a nastpnie podkatalogu wewntrz tego 
//			//   katalogu. Operacja zwraca nowy obiekt DirectoryInfoNotify zarejestrowany 
//			//   z tym samym obiektem DirectoryInfoObserver co obiekt DirInfo
//			DirInfo.Create();
//			DirectoryInfoNotify SubDirInfo = DirInfo.CreateSubdirectory("new");
//			Observer.Register(SubDirInfo);
//
//			// Usunicie podkatalogu
//			SubDirInfo.Delete(true);
//
//			// Zwolnienie zasobw
//			Observer.UnRegister(DirInfo);

		}
 

		public class DirectoryInfoNotify
		{
			public DirectoryInfoNotify(string path)
			{
				internalDirInfo = new DirectoryInfo(path);
			}


			private DirectoryInfo internalDirInfo = null;
			public event CancelEventHandler BeforeCreate;
			public event EventHandler AfterCreate;
			public event EventHandler AfterCreateSubDir;
			public event EventHandler AfterDelete;
			public event EventHandler AfterMoveTo;


			protected virtual void OnBeforeCreate(CancelEventArgs e)
			{
                CancelEventHandler beforeCreate = BeforeCreate;
				if (beforeCreate != null)
				{
					beforeCreate(this, e);
				}
			}
			
			protected virtual void OnAfterCreate()
			{
                EventHandler afterCreate = AfterCreate;
                if (afterCreate != null)
				{
					afterCreate(this, new EventArgs());
				}
			}

			protected virtual void OnAfterCreateSubDir()
			{
                EventHandler afterCreateSubDir = AfterCreateSubDir;
                if (afterCreateSubDir != null)
				{
					afterCreateSubDir(this, new EventArgs());
				}
			}

			protected virtual void OnAfterDelete()
			{
                EventHandler afterDelete = AfterDelete;
                if (afterDelete != null)
				{
					afterDelete(this, new EventArgs());
				}
			}

			protected virtual void OnAfterMoveTo()
			{
                EventHandler afterMoveTo = AfterMoveTo;
                if (afterMoveTo != null)
				{
					afterMoveTo(this, new EventArgs());
				}
			}


            //  Skadowe do obsugi zdarze
			public void Create()
			{
	//			internalDirInfo.Create();
	//			OnAfterCreate();
				CancelEventArgs args = new CancelEventArgs(false);
				OnBeforeCreate(args);

				if (!args.Cancel)
				{
					internalDirInfo.Create();
					OnAfterCreate();
				}
			}

			public DirectoryInfoNotify CreateSubdirectory(string path)
			{
				DirectoryInfo subDirInfo = internalDirInfo.CreateSubdirectory(path);
				OnAfterCreateSubDir();

				return (new DirectoryInfoNotify(subDirInfo.FullName));
			}

			public void Delete(bool recursive)
			{
				internalDirInfo.Delete(recursive);
				OnAfterDelete();
			}

			public void Delete()
			{
				internalDirInfo.Delete();
				OnAfterDelete();
			}

			public void MoveTo(string destDirName)
			{
				internalDirInfo.MoveTo(destDirName);
				OnAfterMoveTo();
			}


			// Pozostae skadowe
			public string FullName 
			{
				get {return (internalDirInfo.FullName);}
			}
			public string Name 
			{
				get {return (internalDirInfo.Name);}
			}
			public DirectoryInfoNotify Parent 
			{
				get {return (new DirectoryInfoNotify(internalDirInfo.Parent.FullName));}
			}
			public DirectoryInfoNotify Root 
			{
				get {return (new DirectoryInfoNotify(internalDirInfo.Root.FullName));}
			}


			public override string ToString()
			{
				return (internalDirInfo.ToString());
			}
		}

		public class DirectoryInfoObserver
		{
			public DirectoryInfoObserver() {}


			public void Register(DirectoryInfoNotify dirInfo)
			{
				dirInfo.BeforeCreate += new CancelEventHandler(BeforeCreateListener);
        		dirInfo.AfterCreate += new EventHandler(AfterCreateListener);
				dirInfo.AfterCreateSubDir += 
					new EventHandler(AfterCreateSubDirListener);
				dirInfo.AfterMoveTo += new EventHandler(AfterMoveToListener);
				dirInfo.AfterDelete += new EventHandler(AfterDeleteListener);
			}

			public void UnRegister(DirectoryInfoNotify dirInfo)
			{
				dirInfo.BeforeCreate -= new CancelEventHandler(BeforeCreateListener);
				dirInfo.AfterCreate -= new EventHandler(AfterCreateListener);
				dirInfo.AfterCreateSubDir -= 
					new EventHandler(AfterCreateSubDirListener);
				dirInfo.AfterMoveTo -= new EventHandler(AfterMoveToListener);
				dirInfo.AfterDelete -= new EventHandler(AfterDeleteListener);
			}


			public void BeforeCreateListener(object sender, CancelEventArgs e)
			{
				if (!e.Cancel)
				{
					if (!((DirectoryInfoNotify)sender).Root.FullName.Equals(@"d:\"))
					{
						e.Cancel = true;
					}
					else
					{
						Console.WriteLine(
							"Powiadomienie PRZED utworzeniem katalogu--wysyajcy: " +
							((DirectoryInfoNotify)sender).FullName);
					}
				}
			}

			public void AfterCreateListener(object sender, EventArgs e)
			{
                Console.WriteLine("Powiadomienie po utworzeniu katalogu--wysyajcy: " + 
					((DirectoryInfoNotify)sender).FullName);
			}

			public void AfterCreateSubDirListener(object sender, EventArgs e)
			{
                Console.WriteLine("Powiadomienie po utworzeniu podkatalogu--wysyajcy: " + 
					((DirectoryInfoNotify)sender).FullName);
			}

			public void AfterMoveToListener(object sender, EventArgs e)
			{
                Console.WriteLine("Powiadomienie o przeniesieniu katalogu--wysyajcy: " + 
					((DirectoryInfoNotify)sender).FullName);
			}

			public void AfterDeleteListener(object sender, EventArgs e)
			{
                Console.WriteLine("Powiadomienie o usuniciu katalogu--wysyajcy: " + 
					((DirectoryInfoNotify)sender).FullName);
			}
		}
		#endregion

        #region "9.6 PPrzekazywanie specjalizowanych parametrw do zdarzenia i ze zdarzenia"
        // Zobacz klasy HashtableObserver i HashtableSubject w recepturze 9.9
        #endregion 
        
        #region "9.7 Zaawansowany mechanizm wyszukiwania interfejsw"
        public static void FindSpecificInterfaces()
		{
			Type[] types = new Type[3] {Type.GetType("System.ICloneable"), Type.GetType("System.Collections.ICollection"), Type.GetType("System.IAppDomainSetup")};
			Type[] interfaces = SearchInterfacesOfType(Type.GetType("System.Collections.ArrayList"), types);

			if (interfaces.Length > 0) 
			{
                Console.WriteLine("Znaleziono interfejsy speniajce kryteria:");   
				for(int counter =0; counter < interfaces.Length; counter++)
				{
                    Console.WriteLine("\tNazwa interfejsu: " + 
						interfaces[counter].ToString());
                    Console.WriteLine("\tTyp bazowy interfejsu: " + 
						interfaces[counter].BaseType);
					foreach (object attr in 
						interfaces[counter].GetCustomAttributes(false))
					{
                        Console.WriteLine("\t\tAtrybuty interfejsu: " + attr.ToString());
					}
				}
			}
			else
			{
                Console.WriteLine("\t\tNiczego nie znaleziono");
			}
		}


        public static Type[] SearchInterfacesOfType(Type searchedType, Type[] interfaceNames)
        {
	        TypeFilter filter = new TypeFilter(InterfaceFilterCallback);
	        Type[] interfaces =  searchedType.FindInterfaces(filter, interfaceNames);

	        return (interfaces);
        }


        public static bool InterfaceFilterCallback(Type type, object criteria)
        {
	        foreach (Type interfaceName in (Type[])criteria)
	        {
                if (type.IsInstanceOfType(interfaceName))
		        {
			        return (true);
		        }
	        }

	        return (false);
        }
//
        //// Filtr wyszukujcy wszystkich interfejsw zdefiniowanych w obrbie okrelonej przestrzeni nazw (w tym przypadku System.Collection):
        //public static bool IfaceFilterCallback(Type type, object criteria)
        //{
        //    return (type.Namespace == "System.Collections");
        //}
//		
        ////Filtr wyszukujcy wszystkich zaimplementowanych interfejsw zawierajcych metod Add, ktra zwraca warto Int32:
        public static bool IfaceFilterCallback(Type type, object criteria)
        {
            MethodInfo mi = type.GetMethod("Add");
            if (mi != null &&
                mi.ReturnType == Type.GetType("System.Int32"))
            {
                return (true);
            }
            else
            {
                return (false);
            }
        }
//		
        //Filtr wyszukujcy wszystkich zaimplementowanych interfejsw zaadowanych z bufora GAC:
//		public static bool IfaceFilterCallback(Type type, object criteria)
//		{
//			if (type.Assembly.GlobalAssemblyCache)
//			{
//				return (true);
//			}
//			else
//			{
//				return (false);
//			}
//		}
//		
        //		//Filtr wyszukujcy wszystkich zaimplementowanych interfejsw zdefiniowanych w obrbie kompilata z numerem wersji 1.0.3300.0:
//		public static bool IfaceFilterCallback(Type type, object criteria)
//		{
//			if (type.Assembly.FullName.IndexOf("Version=1.0.3300.0") >= 0)
//			{
//				return (true);
//			}
//			else
//			{
//				return (false);
//			}
//		}
        #endregion

        #region "9.8 Zaawansowany mechanizm wyszukiwania skadowych"
        public void TestSearchMembers()
		{
			MemberInfo[] members = SearchMembersByReturnType(this.GetType(), 
				Type.GetType("System.Int32"));

			if (members.Length > 0) 
			{
                Console.WriteLine("Znaleziono skadowe speniajce kryteria:");

                // Wywietlenie informacji dla kadej znalezionej skadowej.
				for(int counter = 0; counter < members.Length; counter++)
				{
                    Console.WriteLine("\tNazwa skadowej: " + 
						members[counter].ToString());
                    Console.WriteLine("\tTyp skadowej: " + 
						members[counter].MemberType);
					foreach (object attr in 
						members[counter].GetCustomAttributes(false))
					{
                        Console.WriteLine("\t\tAtrybuty skadowej:" + attr.ToString());
					}
				}
			}
			else
			{
                Console.WriteLine("\t\tNiczego nie znaleziono");
			}
		}
        
		public MemberInfo[] SearchMembersByReturnType(Type searchedType, Type returnType)
		{
            // Delegat porwnujcy typ zwracanej wartoci skadowej
            // z parametrem  returnType.

			MemberFilter filterCallback = new MemberFilter(ReturnTypeFilter);
    
			MemberInfo[] members = searchedType.FindMembers(MemberTypes.All, 
				BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic | BindingFlags.Static, 
				filterCallback, 
				returnType);

			return (members);
		}

        private bool ReturnTypeFilter(MemberInfo member, object criteria)
        {
            // Uzyskanie typu zwracanej wartoci z metody lub waciwoci.
	        Type returnType = null;
	        if (member is MethodInfo)
	        {
		        returnType = ((MethodInfo)member).ReturnType;
	        }
	        else if (member is PropertyInfo)
	        {
		        returnType = ((PropertyInfo)member).PropertyType;
	        }
	        else
	        {
		        return (false);
	        }

            // Dopasowanie typu zwracanej wartoci
	        if (returnType == ((Type)criteria))
		        return (true);
	        else
		        return (false);
        }
//
        //	Filtr do wyszukiwania pl oznaczonych jako const:
//		public const int ConstIntField = 0;
//		private bool ReturnTypeFilter(MemberInfo member, object criteria)
//		{
//			if (member is FieldInfo)
//			{
//				if (((FieldInfo)member).IsLiteral)
//				{
//					return (true);
//				}
//				else
//				{
//					return (false);
//				}
//			}
//
//			return (false);
//		}
//		
        //	filtr do wyszukiwania pl oznaczonych jako readonly:
//		public readonly int ROntField = 0;
//		private bool ReturnTypeFilter(MemberInfo member, object criteria)
//		{
//			if (member is FieldInfo)
//			{
//				if (((FieldInfo)member).IsInitOnly)
//				{
//					return (true);
//				}
//				else
//				{
//					return (false);
//				}
//			}
//
//			return (false);
//		}
//		
//		//Filtr do wyszukiwania delegata wykorzystywanego przez zdarzenie:
//		public delegate void MyDelegate(int i);
//		public event MyDelegate ev;
//		public void Fire(int i) 
//		{
//			ev += new MyDelegate(this.Fire);
//		}
//		private bool ReturnTypeFilter(MemberInfo member, object criteria)		// ??? DOES NOT WORK
//		{
//			Console.WriteLine("\tTyp skadowej: " + member.MemberType + "\t" + member.Name);
//			if (member is EventInfo)
//			{
//				if (((EventInfo)member).EventHandlerType.FullName.Equals(criteria))
//				{
//					return (true);
//				}
//				else
//				{
//					return (false);
//				}
//			}
//
//			return (false);
//		}
//		
        // Filtr do wyszukiwania waciwoci tylko do odczytu::
//		private string a = "";
//		public string A {get {return (a);}}
//		private bool ReturnTypeFilter(MemberInfo member, object criteria)
//		{
//			if (member is PropertyInfo)
//			{
//				if (((PropertyInfo)member).CanRead && !((PropertyInfo)member).CanWrite)
//				{
//					return (true);
//				}
//				else
//				{
//					return (false);
//				}
//			}
//
//			return (false);
//		}
//		
        // filtr do wyszukiwania metod zawierajcych parametry out:
//		public void foofoo(out int bar){bar = 0;}
//		private bool ReturnTypeFilter(MemberInfo member, object criteria)
//		{
//			if (member is MethodInfo)
//			{
//				ParameterInfo[] params = ((MethodInfo)member).GetParameters();
//				foreach (ParameterInfo param in params)
//				{
//					if (param.IsOut)
//					{
//						return (true);
//						break;
//					}
//				}
//
//				return (false);
//			}
//
//			return (false);
//		}
//		
        //	filtr do wyszukiwania skadowych oznaczonych za pomoc atrybutu System.ObsoleteAttribute:
//		[System.ObsoleteAttribute()]
//		private bool ReturnTypeFilter(MemberInfo member, object criteria)
//		{
//			object[] attrs = member.GetCustomAttributes(false);
//			foreach (object attr in attrs)
//			{
//				if (attr.ToString().Equals("System.ObsoleteAttribute"))
//				{
//					return (true);
//				}
//			}
//
//			return (false);
//		}
//
//		// sprawdzenie, czy typ zagniedony jest delegatem:
//		private bool ReturnTypeFilter(MemberInfo member, Object criteria)
//		{
//			if (member.MemberType == MemberTypes.NestedType)
//			{
//				if (((Type)member).BaseType.ToString().Equals(
//					"System.MulticastDelegate") ||
//					((Type)member).BaseType.ToString().Equals("System.Delegate"))
//				{
//					return (true);
//				}
//
//				return (false);
//			}
//
//			return (false);
//		}
        #endregion

        #region "9.9 Obserwacja dodawania i modyfikowania elementw w tablicy Hashtable"
        public static void TestObserverPattern()
        {
	        // Utworzenie trzech egzemplarzy obiektw hashtable do obserwacji
            ObservableHashtable oh1 = new ObservableHashtable();
            ObservableHashtable oh2 = new ObservableHashtable();
            ObservableHashtable oh3 = new ObservableHashtable();

            //  Utworzenie obiektw-obserwatorw dla trzech obiektw-podmiotw.
	        HashtableObserver observer = new HashtableObserver();

            // Zarejestrowanie podmiotw u obserwatorw.
	        observer.Register(oh1);
	        observer.Register(oh2);
	        observer.Register(oh3);

            //Dowizanie si do zdarze zatwierdzania operacji dodawania i modyfikacji.
            observer.ApproveAdd += new HashtableObserver.Approval(SeekApproval);
            observer.ApproveChange += new HashtableObserver.Approval(SeekApproval);

            // Wykorzystanie obserwowanych obiektw.
            oh1.Add(1, "jeden");
            oh2.Add(2, "dwa");
            oh3.Add(3, "trzy");


            // Wyrejestrowanie obserwowanych obiektw.
            observer.Unregister(oh3);
	        observer.Unregister(oh2);
	        observer.Unregister(oh1);
        }

        public static bool SeekApproval(HashtableEventArgs args)
        {
            // Zezwolenie na zapis w  obiekcie Hashtable wycznie cigw zoonych 
            // z 3 i wikszej liczby znakw..
            string value = (string)args.Value;
            if (value.Length <= 3)
                return true;
            return false;
        }

        // Obiekt - obserwator, ktry bdzie obserwowa zarejestrowany obiekt ObservableHashtable
        public class HashtableObserver
        {
	        public HashtableObserver() {}

            //Konfiguracja delegatw/zdarze w celu zezwolenia na dodanie elementu bd jego modyfikacj.
            public delegate bool Approval(HashtableEventArgs args);
            public event Approval ApproveAdd;
            public event Approval ApproveChange;

	        public void Register(ObservableHashtable hashtable)
	        {
                // Dowizanie si do  zdarze egzemplarza ObservableHashTable.
		        hashtable.BeforeAddItem += 
                    new HashtableEventHandler(BeforeAddListener);
		        hashtable.AfterAddItem += 
                    new HashtableEventHandler(AfterAddListener);
		        hashtable.BeforeChangeItem += 
                    new HashtableEventHandler(BeforeChangeListener);
		        hashtable.AfterChangeItem += 
                    new HashtableEventHandler(AfterChangeListener);
	        }

            public void Unregister(ObservableHashtable hashtable)
	        {
                // Odczenie procedur obsugi od zdarze egzemplarza ObservableHashTable.
                hashtable.BeforeAddItem -= 
                    new HashtableEventHandler(BeforeAddListener);
		        hashtable.AfterAddItem -= 
                    new HashtableEventHandler(AfterAddListener);
		        hashtable.BeforeChangeItem -= 
                    new HashtableEventHandler(BeforeChangeListener);
		        hashtable.AfterChangeItem -= 
                    new HashtableEventHandler(AfterChangeListener);
	        }

            private void CheckApproval(Approval approval, HashtableEventArgs args)
            {
                // Sprawdzenie, ktre obiekty-obserwatory gosuj za zatwierdzeniem operacji.
                foreach (Approval approvalInstance in approval.GetInvocationList())
                {
                    if (!approvalInstance(args))
                    {
                        // Jeli ktrakolwiek z zainteresowanych stron
                        // nie wyraa zgody, rezygnacja z dodawania. Domylnie zgoda.

                        args.KeepChanges = false;
                        break;
                    }
                }
            }

	        public void BeforeAddListener(object sender, HashtableEventArgs args)
	        {
                // Sprawdzenie, czy obserwatory s gotowe do zatwierdzania.
                Approval approveAdd = ApproveAdd; 
                if (approveAdd != null)
                {
                    CheckApproval(approveAdd, args);
                }

                Debug.WriteLine("[POWIADOMIENIE] Przed dodaniem...: Add Approval = " +
                                    args.KeepChanges.ToString());
	        }

	        public void AfterAddListener(object sender, HashtableEventArgs args)
	        {
                Debug.WriteLine("[POWIADOMIENIE] ...Po dodaniu: Elementy, ktrych dodanie zatwierdzono: " + 
                                    args.KeepChanges.ToString());
	        }

	        public void BeforeChangeListener(object sender, HashtableEventArgs args)
	        {
                // Sprawdzenie, czy obserwatory s gotowe do zatwierdzania.
                Approval approveChange = ApproveChange;
                if (approveChange != null)
                {
                    CheckApproval(approveChange, args);
                }

                Debug.WriteLine("[POWIADOMIENIE] Przed modyfikacj...: Change Approval = " +
                                    args.KeepChanges.ToString());
	        }

	        public void AfterChangeListener(object sender, HashtableEventArgs args)
	        {
                Debug.WriteLine("[POWIADOMIENIE] ...Po modyfikacji: Elementy zatwierdzone do modyfikacji: " + 
                                    args.KeepChanges.ToString());
	        }
        }

        public class ObservableHashtable : Hashtable
        {
	        public event HashtableEventHandler BeforeAddItem;
	        public event HashtableEventHandler AfterAddItem;
	        public event HashtableEventHandler BeforeChangeItem;
	        public event HashtableEventHandler AfterChangeItem;

	        protected virtual bool OnBeforeAdd(HashtableEventArgs e)
	        {
                HashtableEventHandler beforeAddItem = BeforeAddItem; 
                if (beforeAddItem != null)
		        {
			        beforeAddItem(this, e);
			        return (e.KeepChanges);
		        }

		        return (true);
	        }

	        protected virtual void OnAfterAdd(HashtableEventArgs e)
	        {
                HashtableEventHandler afterAddItem = AfterAddItem; 
                if (afterAddItem != null)
		        {
			        afterAddItem(this, e);
		        }
	        }

	        protected virtual bool OnBeforeChange(HashtableEventArgs e)
	        {
                HashtableEventHandler beforeChangeItem = BeforeChangeItem; 
                if (beforeChangeItem != null)
		        {
			        beforeChangeItem(this, e);
			        return (e.KeepChanges);
		        }

		        return (true);
	        }

	        protected virtual void OnAfterChange(HashtableEventArgs e)
	        {
                HashtableEventHandler afterChangeItem = AfterChangeItem; 
                if (afterChangeItem != null)
		        {
			        afterChangeItem(this, e);
		        }
	        }

	        public override void Add(object key, object value)
	        {
		        HashtableEventArgs hashArgs = new HashtableEventArgs(key, value);
		        if(OnBeforeAdd(hashArgs))
		        {
			        base.Add(key, value);
		        }
		        else
		        {
                    Debug.WriteLine("Nie wolno dodawa kluczy bd wartoci");
		        }

		        OnAfterAdd(hashArgs);
	        }

	        public override object this[object key] 
	        {
		        get 
		        {
			        return (base[key]);
		        }
		        set 
		        {
                    //  Sprawdzenie, czy wystpia prba modyfikacji klucza. Jeli nie  dodanie go.
                    if (base.ContainsKey(key))
                    {
                        HashtableEventArgs hashArgs = new HashtableEventArgs(key, value);

                        if (OnBeforeChange(hashArgs))
                        {
                            base[key] = value;
                        }
                        else
                        {
                            Debug.WriteLine("Nie wolno modyfikowa wartoci");
                        }

                        OnAfterChange(hashArgs);
                    }
                    else
                    {
                        Debug.WriteLine("Element nie istnieje, dodaj go.");
                        Add(key, value);
                    }
		        }
	        }
        }


		// Klasa obsugi zdarze obiektu Hashtable
		[Serializable]
		public delegate void HashtableEventHandler(object sender, HashtableEventArgs args);

        // Argumenty zdarze klasy HashtableSubject
		public class HashtableEventArgs : EventArgs
		{
			public HashtableEventArgs(object key, object value)
			{
				this.key = key;
				this.value = value;
			}

			private object key = null;
			private object value = null;
			private bool keepChanges = true;

			public bool KeepChanges
			{
				get {return (keepChanges);}
				set {keepChanges = value;}
			}

			public object Key
			{
				get {return (key);}
			}

			public object Value
			{
				get {return (value);}
			}
		}
	    #endregion

        #region "9.10 Wykorzystanie hakw do klawiszy Windows"
        // Patrz projekt KeyboardHookRecipe...
        #endregion

        #region "9.11 ledzenie operacji wykonywanych mysz i reagowanie na nie"
        // Patrz projekt MouseHookRecipe project...
		#endregion 

        #region "9.12 Zastosowanie metod anonimowych"
        public static void TestUsingAnonymousMethods()
		{
			OldWay ow = new OldWay();
			ow.WorkItOut();

			InlineWay iw = new InlineWay();
			iw.WorkItOut();

			DirectAssignmentWay diw = new DirectAssignmentWay();
			diw.WorkItOut();

			GenericWay gw = new GenericWay();
			gw.WorkItOut();

			GenericEventConsumer gec = new GenericEventConsumer();
			gec.Test();

            OuterVars ov = new OuterVars();
            ov.SeeOuterWork();
		}

        class OuterVars
        {
            // Deklaracja delegata.
            delegate int Count();

            public void SeeOuterWork()
            {
                int count = 0;
                int total = 0;
                Count countUp = delegate { return count++; };
                for(int i=0;i<10;i++)
                {
                    total += countUp();
                }
                Debug.WriteLine("Suma = " + total);
            }
        }

		class OldWay
		{
            // Deklaracja delegata.
			delegate int DoWork(string work);

            // Metoda tworzca egzemplarza delegata i wywoujca go.
			public void WorkItOut()
			{
                //  Utworzenie egzemplarza.
				DoWork dw = new DoWork(DoWorkMethodImpl);
                // Wywoanie delegata.
				int i = dw("DoWorkMethodImpl1");
			}

            // Metoda, z ktr jest powizany delegat poprzez tak sam sygnatur
            // Dziki temu jest wywoywana w momencie wywoania delegata.

			public int DoWorkMethodImpl(string s)
			{
				Console.WriteLine(s);
				return s.GetHashCode();
			}
		}

		class InlineWay
		{
            // Deklaracja delegata.
			delegate int DoWork(string work);

            // Metoda tworzca egzemplarza delegate i wywoujca go
			public void WorkItOut()
			{
                // Deklaracja egzemplarza.
				DoWork dw = delegate(string s)
				{
					Console.WriteLine(s);
					return s.GetHashCode();
				};
                // Wywoanie delegata.
				int i = dw("DoWorkMethodImpl1");
			}
		}

		class DirectAssignmentWay
		{
            // Deklaracja delegata.
			delegate int DoWork(string work);

            // Metoda tworzca egzemplarz delegata i wywoujca go.
			public void WorkItOut()
			{
                // Deklaracja egzemplarza i przypisanie metody.
				DoWork dw = DoWorkMethodImpl;
                // Wywoanie delegata.
				int i = dw("DoWorkMethodImpl1");
			}
            // Metoda, z ktr jest powizany delegat poprzez tak sam sygnatur.
            // Dziki temu jest wywoywana w momencie wywoania delegata.
			public int DoWorkMethodImpl(string s)
			{
				Console.WriteLine(s);
				return s.GetHashCode();
			}
		}

		class GenericWay
		{
            // Deklaracja delegatw generycznych.
			delegate T DoGenericWork<T>(T t);

            // Metoda tworzca dwa egzemplarze delegatw i wywoujca je.
			public void WorkItOut()
			{
				DoGenericWork<string> dwString = delegate(string s)
				{
					Console.WriteLine(s);
					return s;
				};

                // Wywoanie tekstowego delegata.
				string retStr = dwString("DoWorkMethodImpl1");

				DoGenericWork<int> dwInt = delegate(int i)
				{
					Console.WriteLine(i);
					return i;
				};

                // Wywoanie delegata int.
				int j = dwInt(5);

			}
		}

		public class GenericEvent
		{
			// Deklaracja generycznego delegata.
			public delegate T DoGenericWork<T>(T t);
			public event DoGenericWork<string> DoingStringWork;
			public event DoGenericWork<int> DoingIntWork;

			public void WorkItOut()
			{
				DoingStringWork("Przetwarzanie tekstu");
				DoingIntWork(5);
			}
		}

		public class GenericEventConsumer
		{
			public void Test()
			{
				GenericEvent ge = new GenericEvent();
				ge.DoingStringWork += new GenericEvent.DoGenericWork<string>(ge_DoingStringWork);
				ge.DoingIntWork += new GenericEvent.DoGenericWork<int>(ge_DoingIntWork);
			}
			int ge_DoingIntWork(int t)
			{
				throw new NotImplementedException();
			}
			string ge_DoingStringWork(string t)
			{
				throw new NotImplementedException();
			}
		}

		#endregion

        #region "9.13 Lepsza konfiguracja metod obsugi zdarze"
        class IWannaKnowNow
		{
			public static void Test()
			{
				eNewsPaper DailyBitFlash = new eNewsPaper();
				DailyBitFlash.NewsEvent +=
						   new EventHandler<NewsEventArgs>(BreakingNews);
				DailyBitFlash.SubscriptionExpired +=
						   new EventHandler<ExpiredEventArgs>(Expired);

                // Wysanie aktualnoci.
                DailyBitFlash.TransmitBreakingNews("Legia Mistrzem Polski!");
                DailyBitFlash.TransmitBreakingNews("Polska reprezentacja w pfinale M!");
                DailyBitFlash.TransmitBreakingNews("Premiera VS2006");

				// oferta dla subskrybenta, ktrego okres subsktrypcji koczy si
				string offer = "Twoja subskrypcja skoczya si!";
				offer += "Zamw j teraz, a uzyskasz nowe 98 tygodni za 50 PLN!";
				DailyBitFlash.NotifySubscriptionExpired(offer);

				IWannaKnowThen.TryMe();
			}

			private static void BreakingNews(object src, NewsEventArgs nea)
			{
				Console.WriteLine(nea.LatestNews);
			}

			private static void Expired(object src, ExpiredEventArgs eea)
			{
				Console.WriteLine(eea.NewSubscriptionOffer);
			}

		}

		public class NewsEventArgs : EventArgs
		{
			private string _latestNews;

			public NewsEventArgs(string latestNews)
			{
				_latestNews = latestNews;
			}
			public string LatestNews
			{
				get { return _latestNews; }
			}
		}

		public class ExpiredEventArgs : EventArgs
		{
			private string _offer;

			public ExpiredEventArgs(string newOffer)
			{
				_offer = newOffer;
			}
			public string NewSubscriptionOffer
			{
				get { return _offer; }
			}
		}

		public class eNewsPaper
		{
			public event EventHandler<NewsEventArgs> NewsEvent;

			public void TransmitBreakingNews(string news)
			{
				// Skopiowanie do zmiennej tymczasowej w celu zapewnienia bezpieczestwa wtkw.
				EventHandler<NewsEventArgs> breakingNews = NewsEvent;
				if (breakingNews != null)
					breakingNews(this, new NewsEventArgs(news));
			}

			// kiedy wygasa subskrypcja.
			public event EventHandler<ExpiredEventArgs> SubscriptionExpired;

			public void NotifySubscriptionExpired(string newOffer)
			{
                EventHandler<ExpiredEventArgs> subscriptionExpired =
                    SubscriptionExpired;
				if (subscriptionExpired != null)
					subscriptionExpired(this, new ExpiredEventArgs(newOffer));
			}
		}

		class IWannaKnowThen
		{
			public static void TryMe()
			{
				OldNewsPaper DailyPaperFlash = new OldNewsPaper();
				DailyPaperFlash.NewsEvent +=
					new OldNewsPaper.NewsEventHandler(StaleNews);
				DailyPaperFlash.SubscriptionExpired +=
					new OldNewsPaper.SubscriptionExpiredEventHandler(Expired);

				// wysanie wiadomoci
                DailyPaperFlash.TransmitStaleNews("Legia zdobya mistrzostwo Polski!");
                DailyPaperFlash.TransmitStaleNews("Polska reprezentacja w pfinale M!");
                DailyPaperFlash.TransmitStaleNews("Premiera VS2006");

				// oferta dla subskrybenta, ktrego okres subskrypcji si skoczy
                string offer = "Twoje subskrypcja skoczya si!";
				offer += "Zamw j teraz, a uzyskasz 24 tygodnie za 50 PLN!";
				DailyPaperFlash.NotifySubscriptionExpired(offer);
			}

			private static void StaleNews(object src, OldNewsEventArgs nea)
			{
				Console.WriteLine(nea.LatestNews);
			}

			private static void Expired(object src, OldExpiredEventArgs eea)
			{
				Console.WriteLine(eea.NewSubscriptionOffer);
			}
		}

		public class OldNewsEventArgs : EventArgs
		{
			private string _latestNews;

			public OldNewsEventArgs(string latestNews)
			{
				_latestNews = latestNews;
			}
			public string LatestNews
			{
				get { return _latestNews; }
			}
		}

		public class OldExpiredEventArgs : EventArgs
		{
			private string _offer;

			public OldExpiredEventArgs(string newOffer)
			{
				_offer = newOffer;
			}
			public string NewSubscriptionOffer
			{
				get { return _offer; }
			}
		}

		public class OldNewsPaper
		{
			// pobranie wiadomoci
			public delegate void NewsEventHandler(Object sender, OldNewsEventArgs nea);
			public event NewsEventHandler NewsEvent;

			public void TransmitStaleNews(string news)
			{
                // Skopiowanie do zmiennej tymczasowej w celu zachowania bezpieczestwa wtku.
                NewsEventHandler newsEvent = NewsEvent;
                if (newsEvent != null)
                    newsEvent(this, new OldNewsEventArgs(news));
			}

			// czy subskrypcja wygasa?
			public delegate void SubscriptionExpiredEventHandler(Object sender, OldExpiredEventArgs eea);
			public event SubscriptionExpiredEventHandler SubscriptionExpired;

			public void NotifySubscriptionExpired(string newOffer)
			{
                SubscriptionExpiredEventHandler subscriptionExpired =
                    SubscriptionExpired;
				if (subscriptionExpired != null)
					subscriptionExpired(this, new OldExpiredEventArgs(newOffer));
			}

		}
		#endregion

        #region "9.14 Wykorzystywanie rnych modyfikatorw parametrw w metodach anonimowych"
        public static void TestParameterModifiers()
		{
			ParameterMods pm = new ParameterMods();
			pm.WorkItOut();

			OldParams op = new OldParams();
			op.WorkItOut();

			OuterVariablesParameterModifiers ovpm = new OuterVariablesParameterModifiers();
			ovpm.TestParams();
		}

		class ParameterMods
		{
            // Deklaracja delegata z parametrem out.
			delegate int DoOutWork(out string work);
            // Deklaracja delegata z parametrem ref.
			delegate int DoRefWork(ref string work);
            // Deklaracja delegata z parametrem params.
			delegate int DoParamsWork(params object[] workItems);
			// Deklaracja delegata z symulowanym parametrem params.
			delegate int DoNonParamsWork(object[] workItems);

			// Metoda tworzca egzemplarz delegata i wywoujca go
			public void WorkItOut()
			{
				// Deklaracja egzemplarza i przypisanie metody.
				DoOutWork dow = delegate(out string s)
				{
					s = "WorkFinished";
					Console.WriteLine(s);
					return s.GetHashCode();
				};
				// Wywoanie delegata.
				string work;
				int i = dow(out work);
				Console.WriteLine(work);

                // Deklaracja egzemplarza i przypisanie metody.
				DoRefWork drw = delegate(ref string s)
				{
					Console.WriteLine(s);
					s = "WorkFinished";
					return s.GetHashCode();
				};
				// Wywoanie delegata.
				work = "WorkStarted";
				i = drw(ref work);
				Console.WriteLine(work);

				// "params nie jest prawidowy w tym kontekcie"
				//DoParamsWork dpw = delegate(params object[] workItems)
				//{
				//    foreach (object o in workItems)
				//    {
				//        Console.WriteLine(o.ToString());
				//        return o.GetHashCode();
				//    }
				//};

				// Obejcie problemw z parametrem params poprzez uycie tablicy object[],
				// ktra zwraca niepowizan liczb parametrw metody.
				// Przy zastosowaniu tego sposobu nie korzystamy z waciwoci kompilatora 
				// polegajcej na niejawnym utworzeniu tablicy obiektw.
				DoNonParamsWork dnpw = delegate(object[] items)
				{
					foreach (object o in items)
					{
						Console.WriteLine(o.ToString());
					}
					if (items.Length > 0)
						return items[0].GetHashCode();
					else
						return -1;
				};
				// Wywoanie delegata
				i = dnpw(new object[]{"WorkItem1", 5, 65.99, true});
			}
		}

		class OldParams
		{
			// Deklaracja delegata
			delegate int DoWork(params string [] workItems);

			// Metoda tworzca egzemplarz obiektu i wywoujca delegata
			public void WorkItOut()
			{
				// Deklaracja egzemplarza
				DoWork dw = new DoWork(DoWorkMethodImpl);
				string[] items = new string[3];
				items[0] = "element 0";
                items[1] = "element 1";
                items[2] = "element 2";
				// Wywoanie delegata
				int i = dw(items);

				items = new string[1];
                items[0] = "element 0";
				// Wywoanie delegata.
				i = dw(items);

			}

			// Metoda, z ktr jest powizany delegat poprzez sygnatur, 
			// a zatem metoda jest wywoywana w przypadku wywoania delegata.
			public int DoWorkMethodImpl(params string [] items)
			{
				foreach (string s in items)
				{
					Console.WriteLine(s);
				}
				return items.GetHashCode();
			}
		}

		class OuterVariablesParameterModifiers
		{
			// Deklaracja delegata
			delegate int DoWork(string work);

			public void TestParams(params string[] items)
			{
				// Deklaracja egzemplarza.
				DoWork dw = delegate(string s)
				{
					Console.WriteLine(s);
					foreach (string item in items)
					{
						Console.WriteLine(item);
					}
					return s.GetHashCode();
				};
				// Wywoanie delegata
				int i = dw("DoWorkMethodImpl1");
			}

			//public void TestOut(out string outStr)
			//{
			//    // Deklaracja egzemplarza
			//    DoWork dw = delegate(string s)
			//    {
			//        Console.WriteLine(s);
			//        // Powoduje bd CS1628: 
			//        // "Cannot use ref or out parameter 'outStr' inside an 
			//        // anonymous method block"
			//        //outStr = s;
			//        return s.GetHashCode();
			//    };
			//    // Wywoanie delegata
			//    int i = dw("DoWorkMethodImpl1");
			//}

			//public void TestRef(ref string refStr)
			//{
			//    // Deklaracja egzemplarza
			//    DoWork dw = delegate(string s)
			//    {
			//        Console.WriteLine(s);
			//        // Powoduje bd CS1628: 
			//        // "Cannot use ref or out parameter 'refStr' inside an 
			//        // anonymous method block"
			//        // refStr = s;
			//        return s.GetHashCode();
			//    };
			//    // Wywoanie delegata
			//    int i = dw("DoWorkMethodImpl1");
			//}
		}

		#endregion

        #region "9.15 Zastosowanie domkni w jzyku C#"
        /// <summary>
		/// Klasa reprezentujca handlowcw...
		/// </summary>
		class SalesWeasel
		{
			#region CTOR
			public SalesWeasel(string name,
								decimal annualQuota,
								decimal commissionRate)
			{
				_name = name;
				_annualQuota = annualQuota;
				_commissionRate = commissionRate;
			}
			#endregion //CTOR

			#region Private members
			private string _name;
			private decimal _annualQuota;
			private decimal _commissionRate;
			private decimal _commission = 0m;
			private decimal _totalCommission = 0m;
			#endregion // Skadowe prywatne

			#region Waciwoci
			public string Name
			{
				get { return _name; }
			}

			public decimal AnnualQuota
			{
				get { return _annualQuota; }
			}

			public decimal CommissionRate
			{
				get { return _commissionRate; }
			}

			public decimal Commission
			{
				get { return _commission; }
				set
				{
					_commission = value;
					_totalCommission += _commission;
				}
			}

			public decimal TotalCommission
			{
				get { return _totalCommission; }
			}
			#endregion // Waciwoci
		}

		delegate void CalculateEarnings(SalesWeasel weasel);

		static CalculateEarnings GetEarningsCalculator(decimal quarterlySales,
														decimal bonusRate,
														int weaselCount)
		{
			return delegate(SalesWeasel weasel)
			{
                // Zakadamy, e wszyscy sprzedawcy mieli taki sam wkad w kwartalny dochd.
				decimal weaselSalesPortion = quarterlySales / weaselCount;
                //  Obliczenie kwoty przypadajcej na jednego handlowca.
				decimal quarterlyQuota = (weasel.AnnualQuota / 4);
                // Czy handlowiec osign zakadany kwartalny limit?
				if (quarterlySales < quarterlyQuota)
				{
                    // Nie osign minimum, nie ma prowizji.
					weasel.Commission = 0;
				}
                //  Sprawdzenie, czy osignito poziom uprawniajcy do specjalnej premii (200% minimum).
				else if (quarterlySales > (quarterlyQuota * 2.0m))
				{
					decimal baseCommission = quarterlyQuota * weasel.CommissionRate;
					weasel.Commission = (baseCommission +
							((quarterlySales - quarterlyQuota) *
							(weasel.CommissionRate * (1 + bonusRate))));
				}
                else // Standardowa prowizja
				{
					weasel.Commission = weasel.CommissionRate * quarterlySales;
				}
			};
		}

		public static void TestClosure()
		{
            // Utworzenie obiektw opisu handlowcw...
			SalesWeasel[] weasels = new SalesWeasel[3];
			weasels[0] = new SalesWeasel("Czesiek", 100000m, 0.10m);
			weasels[1] = new SalesWeasel("Radek", 200000m, 0.025m);
			weasels[2] = new SalesWeasel("Bogdan", 50000m, 0.001m);

			decimal q1Earnings = 65000m;
			decimal q2Earnings = 20000m;
			decimal q3Earnings = 37000m;
			decimal q4Earnings = 110000m;
			decimal annualEarnings = q1Earnings + q2Earnings +
										q3Earnings + q4Earnings;

            // Konfiguracja kalkulatorw zarobkw dla poszczeglnych kwartaw.
			CalculateEarnings eCalcQ1 =
				GetEarningsCalculator(q1Earnings, 0.10m, weasels.Length);
			CalculateEarnings eCalcQ2 =
				GetEarningsCalculator(q2Earnings, 0.10m, weasels.Length);
			CalculateEarnings eCalcQ3 =
				GetEarningsCalculator(q3Earnings, 0.10m, weasels.Length);
			CalculateEarnings eCalcQ4 =
				GetEarningsCalculator(q4Earnings, 0.15m, weasels.Length);

			// Obliczenie Q1
			WriteQuarterlyReport("Q1", q1Earnings, eCalcQ1, weasels);
            // Obliczenie Q2
			WriteQuarterlyReport("Q2", q2Earnings, eCalcQ2, weasels);
            // Obliczenie Q3
			WriteQuarterlyReport("Q3", q3Earnings, eCalcQ3, weasels);
            // Obliczenie Q4
			WriteQuarterlyReport("Q4", q4Earnings, eCalcQ4, weasels);

			// Zobaczmy, kogo warto zatrzyma...
			WriteCommissionReport(annualEarnings, weasels);

			//Console.ReadLine();
		}

		static void WriteQuarterlyReport(string quarter,
										decimal quarterlySales,
										CalculateEarnings eCalc,
										SalesWeasel[] weasels)
		{
            Console.WriteLine("{0} Prowizja od kwartalnej sprzeday {1}:", 
                quarter, quarterlySales.ToString("C"));
			foreach (SalesWeasel weasel in weasels)
			{
				// obliczenie prowizji
				eCalc(weasel);
				// raport
                Console.WriteLine("Handlowiec {0} uzyska prowizj : {1}", 
                    weasel.Name, weasel.Commission.ToString("C"));
			}
		}

		static void WriteCommissionReport(decimal annualEarnings,
										SalesWeasel[] weasels)
		{
			decimal revenueProduced = ((annualEarnings) / weasels.Length);
			Console.WriteLine("");
            Console.WriteLine("Roczny przychd wynis {0}",
				annualEarnings.ToString("C"));
			Console.WriteLine("");
			foreach (SalesWeasel weasel in weasels)
			{
                Console.WriteLine(" {0} otrzyma {1} przy przychodzie wynoszcym {2}",
					weasel.Name,
					weasel.TotalCommission.ToString("C"),
					revenueProduced.ToString("C"));
                //  Jeli prowizja handlowca przekracza 20% wypracowanego przez niego przychodu
				// zwalniamy go
				if ((revenueProduced * 0.2m) < weasel.TotalCommission)
				{
					Console.WriteLine("      {0} ZWOLNIONY!", weasel.Name);
				}
			}
		}
		#endregion

        #region "9.16 Wykonywanie wielu operacji na licie z wykorzystaniem funktorw"
        public static void TestFunctors()
		{
			// To nie s prawdziwe symbole akcji...
			// OU81
			// C#4VR
			// PCKD
			// BTML
			// NOVB
			// MGDCD
			// GNRCS
			// FNCTR
			// ANYMS
			// PCLS

			StockPortfolio tech = new StockPortfolio(10);
			tech.AddStock("OU81", -10.5);
			tech.AddStock("C#4VR", 2.0);
			tech.AddStock("PCKD", 12.3);
			tech.AddStock("BTML", 0.5);
			tech.AddStock("NOVB", -35.2);
			tech.AddStock("MGDCD", 15.7);
			tech.AddStock("GNRCS", 4.0);
			tech.AddStock("FNCTR", 9.16);
			tech.AddStock("ANYMS", 9.12);
			tech.AddStock("PCLS", 6.11);

			tech.PrintPortfolio("Pocztkowy portfel");
            //  Sprzeda akcji o najwikszym wzrocie.
			List<Stock> best = tech.GetBestPerformers(3);
			tech.SellStocks(best);
            tech.PrintPortfolio("Portfel po sprzeday 3 najlepszych akcji");
		}

		public class Stock
		{
			string _tickerSymbol;
			double _gainLoss;

			public Stock(string ticker, double gainLoss)
			{
				_tickerSymbol = ticker;
				_gainLoss = gainLoss;
			}

			public double GainLoss
			{
				get { return _gainLoss; }
			}

			public string Ticker
			{
				get { return _tickerSymbol; }
			}
		}

		public class StockPortfolio
		{
			List<Stock> _stocks;

			public StockPortfolio(int capacity)
			{
				_stocks = new List<Stock>(capacity);
			}

			public void AddStock(string ticker, double gainLoss)
			{
				_stocks.Add(new Stock(ticker, gainLoss));
			}

			public List<Stock> GetBestPerformers(int bottomNumber)
			{
				int foundItems = 0;

                //  Posortowanie akcji wedug wzrostu kursw z wykorzystaniem funktora dwuargumentowego.
				_stocks.Sort(delegate(Stock lhs, Stock rhs)
				{
                    // Odwrcenie kolejnoci parametrw w celu posortowania akcji od najwyszego do najniszego wzrostu.
                    return Comparer<double>.Default.Compare(rhs.GainLoss, lhs.GainLoss);
				});

                // Zwrcenie akcji speniajcych kryteria za pomoc funktora jednoargumentowego.
				return _stocks.FindAll(delegate(Stock s)
				{
                    //  Akceptacja kolejnych akcji, jeli zaakceptowano ich nie wicej ni zadano
					if (foundItems < bottomNumber)
					{
						string result = "wzrost";
						if (s.GainLoss < 0)
							result = "strata";
                        Console.WriteLine(string.Format("Dodano najlepsz akcj ({0}) z kursem {1} i wzrostem {2}%",
							s.Ticker, result, System.Math.Abs(s.GainLoss)));
                        //  Inkrementacja licznika.
						foundItems++;
						return true;
					}
                    else //  Mamy wszystkie, jakie potrzebujemy.
						return false;

				});
			}

			public void SellStocks(List<Stock> stocks)
			{
				stocks.ForEach(delegate(Stock s)
				{
					_stocks.Remove(s);
				});
			}

			public void PrintPortfolio(string title)
			{
				Console.WriteLine(title);
				_stocks.ForEach(delegate(Stock s)
				{
					string result = "wzrost";
					if (s.GainLoss < 0)
						result = "strata";
					Console.WriteLine("  ({0}) {1} {2}%", s.Ticker, result,
						System.Math.Abs(s.GainLoss));
				});
			}
		}
		#endregion


	}
}
